/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.cache;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.sonarlint.core.plugin.cache.PluginHashes;

public class PluginCache {
    private static final Logger LOG = LoggerFactory.getLogger(PluginCache.class);
    private final Path cacheDir;
    private final Path tmpDirInCacheDir;
    private final PluginHashes hashes;

    PluginCache(Path cacheDir, PluginHashes fileHashes) {
        this.hashes = fileHashes;
        PluginCache.createDirIfNeeded(cacheDir, "user cache");
        this.cacheDir = cacheDir;
        LOG.debug("Plugin cache: {}", (Object)cacheDir.toString());
        this.tmpDirInCacheDir = cacheDir.resolve("_tmp");
        PluginCache.createDirIfNeeded(this.tmpDirInCacheDir, "temp dir");
    }

    public static PluginCache create(Path cachePath) {
        return new PluginCache(cachePath, new PluginHashes());
    }

    public Path getCacheDir() {
        return this.cacheDir;
    }

    @CheckForNull
    public Path get(String filename, String hash) {
        Path cachedFile = this.cacheDir.resolve(hash).resolve(filename);
        if (Files.exists(cachedFile, new LinkOption[0])) {
            return cachedFile;
        }
        LOG.debug("No file found in the cache with name {} and hash {}", (Object)filename, (Object)hash);
        return null;
    }

    public Path get(String filename, String hash, Downloader downloader) {
        Path hashDir = this.hashDir(hash);
        Path targetFile = hashDir.resolve(filename);
        if (Files.notExists(targetFile, new LinkOption[0])) {
            Path tempFile = this.newTempFile();
            this.download(downloader, filename, tempFile);
            String downloadedHash = this.hashes.of(tempFile);
            if (!hash.equals(downloadedHash)) {
                throw new IllegalStateException("INVALID HASH: File " + tempFile + " was expected to have hash " + hash + " but was downloaded with hash " + downloadedHash);
            }
            PluginCache.createDirIfNeeded(hashDir, "target directory in cache");
            PluginCache.renameQuietly(tempFile, targetFile);
        }
        return targetFile;
    }

    private void download(Downloader downloader, String filename, Path tempFile) {
        try {
            downloader.download(filename, tempFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to download " + filename + " to " + tempFile, e);
        }
    }

    private static void renameQuietly(Path sourceFile, Path targetFile) {
        block2: {
            try {
                PluginCache.rename(sourceFile, targetFile);
            }
            catch (Exception e) {
                if (!Files.notExists(targetFile, new LinkOption[0])) break block2;
                throw new IllegalStateException("Fail to move " + sourceFile + " to " + targetFile, e);
            }
        }
    }

    private static void rename(Path sourceFile, Path targetFile) throws IOException {
        try {
            Files.move(sourceFile, targetFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.warn("Atomic rename from {} to {} not supported", (Object)sourceFile, (Object)targetFile);
            Files.move(sourceFile, targetFile, new CopyOption[0]);
        }
    }

    private Path hashDir(String hash) {
        return this.cacheDir.resolve(hash);
    }

    private Path newTempFile() {
        try {
            return Files.createTempFile(this.tmpDirInCacheDir, null, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp file in " + this.tmpDirInCacheDir, e);
        }
    }

    public Path createTempDir() {
        try {
            return Files.createTempDirectory(this.tmpDirInCacheDir, null, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create directory in " + this.tmpDirInCacheDir, e);
        }
    }

    private static void createDirIfNeeded(Path dir, String debugTitle) {
        LOG.debug("Create : {}", (Object)dir);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create " + debugTitle + dir, e);
        }
    }

    public static interface Downloader {
        public void download(String var1, Path var2) throws IOException;
    }
}

